/*
 * Decompiled with CFR 0.152.
 */
package com.chirptheboy.disenchanting;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber
public class Config {
    public static final String CATEGORY_GENERAL = "general";
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec.BooleanValue DISENCHANTER_REQUIRES_XP;
    public static ForgeConfigSpec.BooleanValue DISENCHANTER_RANDOM_ENCHANTMENT;
    public static ForgeConfigSpec.IntValue DISENCHANTER_COST;

    private static void setupFirstBlockConfig() {
        DISENCHANTER_REQUIRES_XP = COMMON_BUILDER.comment("Does disenchanting cost xp?").define("requires_xp", true);
        DISENCHANTER_COST = COMMON_BUILDER.comment("Relative scale of how much XP the disenchanter costs to use (lower requires less XP)").defineInRange("xp_cost", 2, 1, 10);
        DISENCHANTER_RANDOM_ENCHANTMENT = COMMON_BUILDER.comment("Should the disenchanter select a random enchantment to disenchant?").define("random_enchantment", false);
        COMMON_BUILDER.pop();
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
    }

    @SubscribeEvent
    public static void onReload(ModConfig.ModConfigEvent configEvent) {
    }

    static {
        COMMON_BUILDER.comment("General settings").push(CATEGORY_GENERAL);
        Config.setupFirstBlockConfig();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }
}

